// Hasonltsuk ssze a hagyomnyos, a TFileStream- s a
// TMemoryStream alap fjkezels sebessgt fjlban trolt
// vals adatok tlagnak kiszmtsval!

unit AtlagU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    btmLetrehoz: TButton;
    btnFileof: TButton;
    btnMStream: TButton;
    btnFStream: TButton;
    edtLetrehoz: TEdit;
    edtFileof: TEdit;
    edtFStream: TEdit;
    edtMStream: TEdit;
    Label1: TLabel;
    edtAdatmennyiseg: TEdit;
    UpDown1: TUpDown;
    Label2: TLabel;
    procedure btmLetrehozClick(Sender: TObject);
    procedure btnFileofClick(Sender: TObject);
    procedure btnMStreamClick(Sender: TObject);
    procedure btnFStreamClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure edtAdatmennyisegChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
type TSS=(start, stop);

function idomero(ss: TSS; ido: tdatetime):real;
const
  starttime:Tdatetime=0;
var
  diff:integer;
  s1, s2 : TTimeStamp;
begin
  result:=0;
  case ss of
    start: starttime:=ido;
    stop:
      begin
        s1:=dateTimeToTimeStamp(starttime);
        s2:=dateTimeToTimeStamp(ido);
        diff:=s2.time-s1.time;
        result:=diff/1000;
      end;
  end;
end;
procedure TForm1.btmLetrehozClick(Sender: TObject);
var f:file of real;
  i:integer;
  adat:real;
  db:integer;
begin
  Randomize;
  edtLetrehoz.clear;
  edtFileof.clear;
  edtFStream.clear;
  edtMStream.clear;
  caption:='Start';  Beep;
  idomero(start, time);
  assignfile(f,'forgalom.dat');
  rewrite(f);
  try
    db:=1024*strtoint(edtAdatmennyiseg.text)
        div sizeof(real);
  except
    Showmessage('Hibs adatmegads');
    exit;
  end;
  if db<0 then
   begin
    Showmessage('Hibs adatmegads');
    exit;
   end;
  for i:=1 to db do
     begin
       adat:=(100000+random(maxint))/random(maxint);
       write(f,adat);
     end;
  closefile(f);
  edtLetrehoz.text:=floattostr(idomero(stop, time))+' mp';
  caption:='Stop';  Beep;
  btnFileOf.enabled:=true;
  btnFStream.enabled:=true;
  btnMStream.enabled:=true;
end;

procedure TForm1.btnFileofClick(Sender: TObject);
var f:file of real;
  i:integer;
  sum, adat : real;
begin
  caption:='Start';  Beep;
  idomero(start, time);
  assignfile(f,'forgalom.dat');
  filemode:=0;
  reset(f);
  i:=0;
  sum:=0;
  while not eof(f)do
     begin
       read(f,adat);
       inc (i);
       sum:=sum+adat;
     end;
  closefile(f);
  caption:='Stop';  Beep;
  edtFileOf.text:=floattostr(idomero(stop, time))+' mp';
  caption:=floattostr(sum/i);
end;

procedure TForm1.btnFStreamClick(Sender: TObject);
var
 fs : TFileStream;
 i,db : integer;
 sum, adat  : real;

begin
 caption:='Start';  Beep;
 idomero(start, time);
 fs:=TFileSTream.create('Forgalom.dat', fmOpenread);
 sum:=0;;
 db:=fs.Size div sizeof(real);
 for i:=1 to db do
   begin
     fs.read(adat,sizeof(real));
     sum:=sum+adat;
   end;

 fs.Free;
 caption:='Stop';  Beep;
 edtFStream.text:=floattostr(idomero(stop, time))+' mp';
 caption:=floattostr(sum/db);
end;

procedure TForm1.btnMStreamClick(Sender: TObject);
var
 ms : TMemoryStream;
 fs : TFileStream;
 p  : ^ real;
 i,db : integer;
 sum  : real;

begin
 caption:='Start';  Beep;
 idomero(start, time);
 ms:=TMemoryStream.create;
 fs:=TFileSTream.create('Forgalom.dat', fmOpenread);
 ms.SetSize(fs.Size);
 ms.CopyFrom(fs,fs.Size);
 p:=ms.Memory;
 sum:=0;;
 db:=fs.Size div sizeof(real);
 for i:=1 to db do
   begin
     sum:=sum+p^;
     inc(p);
   end;
 fs.Free;
 ms.free;
 caption:='Stop';  Beep;
 edtMStream.text:=floattostr(idomero(stop, time))+' mp';
 caption:=floattostr(sum/db);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  btnFileOf.enabled:=false;
  btnFStream.enabled:=false;
  btnMStream.enabled:=false;
  UpDown1.thousands:=false;
end;

procedure TForm1.edtAdatmennyisegChange(Sender: TObject);
begin
  btnFileOf.enabled:=false;
  btnFStream.enabled:=false;
  btnMStream.enabled:=false;
  edtLetrehoz.clear;
  edtFileof.clear;
  edtFStream.clear;
  edtMStream.clear;
end;

end.
